/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.api.utils;

import com.google.common.base.Suppliers;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_2035;
import net.minecraft.class_2040;
import net.minecraft.class_2096;
import net.minecraft.class_2102;
import net.minecraft.class_2105;
import net.minecraft.class_2960;
import net.minecraft.class_5699;

public final class CodecUtils {
    public static final Codec<class_2096.class_2100> MIN_MAX_INT_CODEC = CodecUtils.createMinMaxCodec(Codec.INT, BoundsFactory.fromOld(class_2096.class_2100::method_35287, class_2096.class_2100::method_9053, class_2096.class_2100::method_35289, class_2096.class_2100.field_9708));
    public static final Codec<class_2096.class_2099> MIN_MAX_DOUBLE_CODEC = CodecUtils.createMinMaxCodec(Codec.DOUBLE, BoundsFactory.fromOld(class_2096.class_2099::method_35285, class_2096.class_2099::method_9050, class_2096.class_2099::method_35286, class_2096.class_2099.field_9705));
    public static final Codec<class_2035[]> ENCHANTMENTS_PREDICATE_CODEC = class_5699.field_40721.flatXmap(json -> {
        try {
            return DataResult.success((Object)class_2035.method_8879((JsonElement)json));
        }
        catch (JsonParseException exception) {
            return DataResult.error(exception::getMessage);
        }
    }, predicate -> {
        JsonArray jsonArray = new JsonArray();
        for (class_2035 enchantmentPredicate : predicate) {
            jsonArray.add(enchantmentPredicate.method_8881());
        }
        return DataResult.success((Object)jsonArray);
    });
    public static final Codec<class_2105> NBT_PREDICATE_CODEC = class_5699.field_40721.flatXmap(json -> {
        try {
            return DataResult.success((Object)class_2105.method_9073((JsonElement)json));
        }
        catch (JsonParseException exception) {
            return DataResult.error(exception::getMessage);
        }
    }, predicate -> DataResult.success((Object)predicate.method_9075()));
    public static final Codec<class_2102> MOB_EFFECTS_PREDICATE_CODEC = class_5699.field_40721.flatXmap(json -> {
        try {
            return DataResult.success((Object)class_2102.method_9064((JsonElement)json));
        }
        catch (JsonParseException exception) {
            return DataResult.error(exception::getMessage);
        }
    }, predicate -> DataResult.success((Object)predicate.method_9068()));
    public static final Codec<class_2040> ENTITY_FLAGS_PREDICATE_CODEC = class_5699.field_40721.flatXmap(json -> {
        try {
            return DataResult.success((Object)class_2040.method_8893((JsonElement)json));
        }
        catch (JsonParseException exception) {
            return DataResult.error(exception::getMessage);
        }
    }, predicate -> DataResult.success((Object)predicate.method_8894()));

    public static <T> Codec<T> withAlternative(Codec<T> primary, Codec<? extends T> alternative) {
        return Codec.either(primary, alternative).xmap(either -> either.map(Function.identity(), Function.identity()), Either::left);
    }

    public static <T> Codec<T> recursive(String name, Function<Codec<T>, Codec<T>> wrapped) {
        return new RecursiveCodec<T>(name, wrapped);
    }

    public static <E> Codec<E> identifierResolver(Function<E, class_2960> toId, Function<class_2960, E> fromId) {
        return class_2960.field_25139.flatXmap(name -> Optional.ofNullable(fromId.apply((class_2960)name)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown element name:" + String.valueOf(name))), e -> Optional.ofNullable((class_2960)toId.apply(e)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Element with unknown name: " + String.valueOf(e))));
    }

    private static <T extends Number, R extends class_2096<T>> Codec<R> createMinMaxCodec(Codec<T> codec, BoundsFactory<T, R> boundsFactory) {
        Codec fullCodec = RecordCodecBuilder.create(instance -> instance.group((App)codec.optionalFieldOf("min").forGetter(bounds -> Optional.ofNullable(bounds.method_9038())), (App)codec.optionalFieldOf("max").forGetter(bounds -> Optional.ofNullable(bounds.method_9042()))).apply((Applicative)instance, boundsFactory::create));
        return Codec.either((Codec)fullCodec, codec).xmap(either -> (class_2096)either.map(Function.identity(), number -> boundsFactory.create(Optional.of(number), Optional.of(number))), bounds -> {
            Optional<Number> max;
            Optional<Number> min = Optional.ofNullable(bounds.method_9038());
            Optional<Number> point = min.equals(max = Optional.ofNullable(bounds.method_9042())) ? min : Optional.empty();
            return point.map(o -> Either.right((Object)((Number)o))).orElseGet(() -> Either.left((Object)bounds));
        });
    }

    public static class RecursiveCodec<T>
    implements Codec<T> {
        private final String name;
        private final Supplier<Codec<T>> wrapped;

        private RecursiveCodec(String name, Function<Codec<T>, Codec<T>> wrapped) {
            this.name = name;
            this.wrapped = Suppliers.memoize(() -> (Codec)wrapped.apply(this));
        }

        public <S> DataResult<Pair<T, S>> decode(DynamicOps<S> ops, S input) {
            return this.wrapped.get().decode(ops, input);
        }

        public <S> DataResult<S> encode(T input, DynamicOps<S> ops, S prefix) {
            return this.wrapped.get().encode(input, ops, prefix);
        }

        public String toString() {
            return "RecursiveCodec[" + this.name + "]";
        }
    }

    @FunctionalInterface
    private static interface BoundsFactory<T extends Number, R extends class_2096<T>> {
        public R create(Optional<T> var1, Optional<T> var2);

        public static <T extends Number, R extends class_2096<T>> BoundsFactory<T, R> fromOld(BiFunction<T, T, R> betweenFunc, Function<T, R> atLeast, Function<T, R> atMost, R any) {
            return (min, max) -> {
                if (min.isPresent() && max.isPresent()) {
                    return (class_2096)betweenFunc.apply((Number)min.get(), (Number)max.get());
                }
                if (min.isPresent()) {
                    return (class_2096)atLeast.apply((Number)min.get());
                }
                if (max.isPresent()) {
                    return (class_2096)atMost.apply((Number)max.get());
                }
                return any;
            };
        }
    }
}

